/* *********************************************************************
    Arduino Nano - TFTDualAnzeige
    hiz 09/2025
 ********************************************************************* */

String VERS = "Vers 1.1 hiz 12/2025";

#include <SPI.h>  // SPI für die Kommunikation

// TFT Rund GC9A01A
/*                Nano  ESP32
VCC 5V
GND GND
SCL Clock           13    GP18
SDA Data In         11    GP23
DC Data/Command     9     GP17 (alt 16)
CS1 Chip Select     10    GP12 (alt 22)
CS2 Chip Select     6
RST1 Reset          8     GP 4
RST2                7
*/
#include "Adafruit_GFX.h"
#include "Adafruit_GC9A01A.h"
#define TFT_DC 9
#define TFT_CS1 10
#define TFT_CS2 6
#define TFT_RST1 8
#define TFT_RST2 7
Adafruit_GC9A01A tft1(TFT_CS1, TFT_DC, TFT_RST1);
Adafruit_GC9A01A tft2(TFT_CS2, TFT_DC, TFT_RST2);
#define PI 3.1415926535897932384626433832795
#define DEG2RAD 0.017453292
int rotation = 0;

    // AnalogEingänge
#define INP1 A1
#define INP2 A2

int lastx[2], lasty[2];
float lastwert[2];
int lVolt1 = -1;
int lVolt2 = -1;

// **************************************************************************
void setup() {
  int cnt;
  Serial.begin(115200);
  while (!Serial)
    ;
  Serial.println(F("TFT-AnalogAnzeigen"));
  Serial.println(VERS);
  pinMode(TFT_CS1, OUTPUT);
  pinMode(TFT_CS2, OUTPUT);

  // Init TFTs
  tft1.begin();
  digitalWrite(TFT_CS1, HIGH);
  tft2.begin();
  digitalWrite(TFT_CS2, HIGH);
  // TFT 1 Setup
  TFTStart(tft1, 1);
  // TFT2 Setup
  TFTStart(tft2, 2);
  digitalWrite(TFT_CS1, HIGH);
  digitalWrite(TFT_CS2, HIGH);
  TFTSkala(tft1, GC9A01A_RED);
  TFTSkala(tft2, GC9A01A_BLUE);
}

// **************************************************************************
void loop() {
  int analog1, analog2;
  analog1 = analogRead(INP1);
  analog2 = analogRead(INP2);
  digitalWrite(TFT_CS2, HIGH);
  if (abs(analog1 - lVolt1) > 2) {
    TFTZeiger(tft1, (float)analog1 * 5 / 1024, GC9A01A_RED, 0);
    lVolt1 = analog1;
  }
  digitalWrite(TFT_CS2, HIGH);
  if (abs(analog2 - lVolt2) > 2) {
    TFTZeiger(tft2, (float)analog2 * 5 / 1024, GC9A01A_BLUE, 1);
    lVolt2 = analog2;
  }
}


// **************************************************************************
// Init TFTs
void TFTStart(Adafruit_GC9A01A tft, int Nr) {
  tft.setRotation(rotation);
  tft.fillScreen(GC9A01A_RED);
  delay(1000);
  tft.fillScreen(GC9A01A_GREEN);
  delay(100);
  tft.fillScreen(GC9A01A_BLUE);
  delay(100);
  tft.fillScreen(GC9A01A_BLACK);
  tft.setCursor(70, 200);
  tft.setTextColor(GC9A01A_WHITE);
  tft.setTextSize(2);
  tft.print("HIZ-TFT");
  tft.println(Nr);
  tft.setTextSize(1);
  tft.setCursor(10, 120);
  tft.print(VERS);
}

void TFTSkala(Adafruit_GC9A01A tft, uint16_t colour) {

  int start_angle = 360 - 120;
  int seg_count = 240 / 3;
  int rx = 120;
  int ry = 120;
  int x = 120;
  int y = 120;
  int w = 20;

  tft.fillScreen(GC9A01A_BLACK);
  //Kreisbogen
  fillArc(tft, x, y, start_angle, seg_count, rx, ry, w, colour);

  // Skalenstriche
  for (int winkel = start_angle; winkel <= start_angle + 240; winkel += 10) {
    float sx = cos((winkel - 90) * DEG2RAD);
    float sy = sin((winkel - 90) * DEG2RAD);
    rx = x + sx * 120;
    ry = y + sy * 120;
    tft.drawLine(x, y, rx, ry, GC9A01A_WHITE);
  }
  // Mitte Schwarz
  tft.fillCircle(x, y, 100, GC9A01A_BLACK);
  // Weisser Punkt
  tft.fillCircle(x, y, 5, GC9A01A_WHITE);
}

// **************************************************************************
// Zeiger
void TFTZeiger(Adafruit_GC9A01A tft, float analog, uint16_t colour, int Nr) {
  float Winkel;
  int xmin, xmax, ymin, ymax;
  float sRadius = 95;
  xmin = 120;
  ymin = 120;

  Winkel = (300 - analog / 5 * 240) * DEG2RAD;

  xmax = (sRadius * sin(Winkel)) + xmin;
  ymax = (sRadius * cos(Winkel)) + ymin;

  digitalWrite(TFT_CS2, HIGH);
  // Ausgabe Zahlenwert
  tft.setCursor(70, 200);
  tft.setTextSize(3);
  tft.setTextColor(GC9A01A_BLACK);
  tft.print(lastwert[Nr]);
  tft.setCursor(70, 200);
  tft.setTextColor(GC9A01A_WHITE);
  tft.print(analog);

  digitalWrite(TFT_CS2, HIGH);


  //Löschen letze Linie
  tft.drawLine(xmin, ymin, lastx[Nr], lasty[Nr], GC9A01A_BLACK);
  tft.drawLine(xmin - 1, ymin, lastx[Nr] - 1, lasty[Nr], GC9A01A_BLACK);
  tft.drawLine(xmin, ymin - 1, lastx[Nr], lasty[Nr] - 1, GC9A01A_BLACK);
  tft.drawLine(xmin + 1, ymin, lastx[Nr] + 1, lasty[Nr], GC9A01A_BLACK);
  tft.drawLine(xmin, ymin + 1, lastx[Nr], lasty[Nr] + 1, GC9A01A_BLACK);
  // Zeichnen Zeiger
  tft.drawLine(xmin, ymin, xmax, ymax, colour);
  tft.drawLine(xmin - 1, ymin, xmax - 1, ymax, colour);
  tft.drawLine(xmin, ymin - 1, xmax, ymax - 1, colour);
  tft.drawLine(xmin + 1, ymin, xmax + 1, ymax, colour);
  tft.drawLine(xmin, ymin + 1, xmax, ymax + 1, colour);
  // Weisser Punkt
  tft.fillCircle(xmin, ymin, 5, GC9A01A_WHITE);
  // letze mWerte merken
  lastwert[Nr] = analog;
  lastx[Nr] = xmax;
  lasty[Nr] = ymax;
}


// #########################################################################
// Draw an arc with a defined thickness
// #########################################################################

// x,y == coords of centre of arc
// start_angle = 0 - 359
// seg_count = number of 3 degree segments to draw (120 => 360 degree arc)
// rx = x axis radius
// yx = y axis radius
// w  = width (thickness) of arc in pixels
// colour = 16 bit colour value
// Note if rx and ry are the same an arc of a circle is drawn

void fillArc(Adafruit_GC9A01A tft, int x, int y, int start_angle, int seg_count, int rx, int ry, int w, unsigned int colour) {

  byte seg = 3;  // Segments are 3 degrees wide = 120 segments for 360 degrees
  byte inc = 3;  // Draw segments every 3 degrees, increase to 6 for segmented ring

  // Draw colour blocks every inc degrees
  for (int i = start_angle; i < start_angle + seg * seg_count; i += inc) {
    // Calculate pair of coordinates for segment start
    float sx = cos((i - 90) * DEG2RAD);
    float sy = sin((i - 90) * DEG2RAD);
    uint16_t x0 = sx * (rx - w) + x;
    uint16_t y0 = sy * (ry - w) + y;
    uint16_t x1 = sx * rx + x;
    uint16_t y1 = sy * ry + y;

    // Calculate pair of coordinates for segment end
    float sx2 = cos((i + seg - 90) * DEG2RAD);
    float sy2 = sin((i + seg - 90) * DEG2RAD);
    int x2 = sx2 * (rx - w) + x;
    int y2 = sy2 * (ry - w) + y;
    int x3 = sx2 * rx + x;
    int y3 = sy2 * ry + y;

    tft.fillTriangle(x0, y0, x1, y1, x2, y2, colour);
    tft.fillTriangle(x1, y1, x2, y2, x3, y3, colour);
  }
}
