#include <Wire.h>
#include <LiquidCrystal_I2C.h>
// SET LCD adress to 0x27
// LCD SDA -> A4
//     SCL -> A5
LiquidCrystal_I2C lcd(0x27, 16, 2);


//*************************************************
// Setup System
//*************************************************
void setup() {
  int cnt;
  Serial.begin(9600);
  // put your setup code here, to run once:
  lcd.begin();
  // Backlight on
  pinMode(13, INPUT);

  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("LC-Display-Test");
  Serial.println("LC-Display-Test");
  delay(1000);
}

//*************************************************
// Program Loop
//*************************************************
void loop() {
  int xpos = 0;
  char cnt = 32;  // Space

  // Endlosschleife
  xpos = 0;
  lcd.clear();
  lcd.setCursor(0, 0);
  while (1 == 1) {
    // Warten auf Tastendruck
    while (digitalRead(13) == HIGH)
      ;
    lcd.print(cnt);

    // Nächstes Zeichen
    cnt = (cnt < 255) ? cnt + 1 : 32;
    if (cnt == 0x80) cnt = 0xA0;  // Lücke in der Tabells überbrücken

    // Nächste Position Zum Zeilenwechsel und Bildwechsel
    xpos++;
    if (xpos == 16) {  // Zeile voll 2. Zeile
      lcd.setCursor(0, 1);
    }
    if (xpos == 32) {  // Display voll, zum Anfang
      xpos = 0;
      lcd.setCursor(0, 0);
    }
    //Warten auf nächste Taste oder Loop
    delay(300);
  }
}
