// Druckmessung

// LCD Display adress to 0x27
// LCD SDA -> A4
//     SCL -> A5
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);


// NeoPixel Strip
#include <Adafruit_NeoPixel.h>
// SETUP YOUR OUTPUT PIN AND NUMBER OF PIXELS
#define PIN1 11
#define NUM_PIXELS 44
#define vel 100  // Velocity in milliseconds
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_PIXELS, PIN1, NEO_RGB + NEO_KHZ800);

//Datenstrukturen für HSV->RGB
struct RGB {
  float Rot;
  float Gruen;
  float Blau;
};
struct HSV {
  float Winkel;
  float Satt;
  float Hell;
};
//Strukturen zum Umrechen HSV->RGB als globale Variable
struct HSV hsv;
struct RGB rgb;

// Analogeingänge für Messstreifen
#define Waage1 A0
#define Waage2 A1
#define Waage3 A2
#define Waage4 A3
// Anzahl Messwerte
int Werte[4];

// Funktionsumschalter
const byte FUNKTION = 2;
int Hell = 80;
int Funktion;
// Helligkeit an AnalogPin 7 - Photowiderstend mit 1 kOhm gegen Msse
#define HellPin A7

//*************************************************
// Setup System
//*************************************************
void setup() {
  int cnt;
  Serial.begin(9600);
  //Headline
  String headline = "Gewichte 3/25";
  Serial.println(headline);

  // Funktiontaste
  pinMode(FUNKTION, INPUT_PULLUP);

  // LC Display 2 Zeilig
  lcd.begin();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(headline);
  lcd.setCursor(0, 1);
  lcd.print("HIZ 3/2025");

  // NeoPixel Strip
  Hell = analogRead(HellPin) / 4;
  strip.begin();
  strip.clear();
  // Farbtest Rot
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, Hell, 0));
    strip.show();
  }
  delay(100);
  // Farbtest Grün

  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(Hell, 0, 0));
    strip.show();
  }
  delay(100);
  // Farbtest blau
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    strip.setPixelColor(cnt, strip.Color(0, 0, Hell));
    strip.show();
  }
  delay(1000);
  strip.clear();
  strip.show();
}

//*************************************************
// Program Loop
//*************************************************
void loop() {

  Funktion = 0;  // Startet mit Funktion 0
  lcd.setCursor(15, 0);
  lcd.print(Funktion);

  // Dauerschleife
  while (1) {
    // Funktionsumschalter
    if (digitalRead(FUNKTION) == 0) {
      while (digitalRead(FUNKTION) == 0)
        ;  // gegen Prellen
      Funktion = (Funktion + 1) % 4;
      Serial.println("ist low " + (String)Funktion);
      lcd.setCursor(15, 0);
      lcd.print(Funktion);
      delay(50);  // Anti prellen
      // NeoStrip löschen
      strip.clear();
      strip.show();
    }
    hsv.Hell = analogRead(HellPin) / 4;
    hsv.Satt = 255;
    //Serial.println(Funktion);
    // Funktionmodus
    switch (Funktion) {
      case 0:
        // Einlesen Werte und auf LCD ausgeben
        Messung();
        delay(300);
        break;
      case 1:
        // Einlesen Werte und auf LCD ausgeben und auf Neostrip
        GewichtColor();
        break;
      case 2:
        Farben();
        break;
      case 3:
        CursorPos();
        break;
      default:
        Serial.println("Falsche Funktion");
        lcd.clear();
        lcd.println("Falsche Funktion");
        lcd.print(Funktion);
        break;
    }
  }
}

//*****************************************************************************************
// Messen und auf LCD ausgeben
//*****************************************************************************************
void Messung() {
  char buff1[24];
  Werte[0] = analogRead(Waage1);
  Werte[1] = analogRead(Waage2);
  Werte[2] = analogRead(Waage3);
  Werte[3]=  analogRead(Waage4);
  // Ausgeben auf LC Display
  snprintf(buff1, 24, "%3d %3d %3d %3d ", Werte[0], Werte[1], Werte[2],Werte[3]);
  lcd.setCursor(0, 1);
  lcd.print(buff1);
}

//*****************************************************************************************
// Gewichte mit Farben auf NeoStrip
//*****************************************************************************************
void GewichtColor() {
  Messung();
  // auf Neostrip
  int anz = NUM_PIXELS / 4;
  // Wert Waage1
  hsv.Winkel = map(Werte[0], 0, 255, 0, 360);
  rgb = Convert2RGB(hsv);
  StripOut(0, anz, rgb);
  // Wert Waage2
  hsv.Winkel = map(Werte[1], 0, 255, 0, 360);
  rgb = Convert2RGB(hsv);
  StripOut(anz + 1, 2 * anz, rgb);
  // Wert Waage3
  hsv.Winkel = map(Werte[2], 0, 255, 0, 360);
  rgb = Convert2RGB(hsv);
  StripOut(2 * anz + 1, 3*anz, rgb);
    // Wert Waage4
  hsv.Winkel = map(Werte[3], 0, 255, 0, 360);
  rgb = Convert2RGB(hsv);
  StripOut(3 * anz + 1, NUM_PIXELS, rgb);
  delay(300);
}

//*****************************************************************************************
// Cursorposition aus Gewichtsdifferenz
//*****************************************************************************************
void Farben() {
  int cnt;
  Messung();
  //Farbverlauf berechnen
  // Grundlast
  float yStep = (Werte[1] - Werte[0]) / NUM_PIXELS / 4;
  float yStart = Werte[0] / 4;
  if (yStep > 0) yStart = 0;
  // Ausgeben auf NeoStrip
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    hsv.Winkel = yStart + cnt * yStep;
    rgb = Convert2RGB(hsv);
    strip.setPixelColor(cnt, strip.Color(rgb.Gruen, rgb.Rot, rgb.Blau));
  }
  strip.show();

  delay(300);
}

//*****************************************************************************************
// Position des Gewichts
//*****************************************************************************************
void CursorPos() {
  int cnt;
  int ymax=400;
  Messung();
  //Positon berechnen
  // Wo ist das Gewicht (Mitte ist NUMPIXELS/2)
  float position = NUM_PIXELS / 2 + NUM_PIXELS / 2 * (Werte[1] - Werte[0]) / ymax;
  // Ausgeben auf NeoStrip
  for (cnt = 0; cnt < NUM_PIXELS; cnt++) {
    if (cnt == (int)position) {
      hsv.Winkel = cnt * 360 / NUM_PIXELS;
      rgb = Convert2RGB(hsv);
      strip.setPixelColor(cnt, strip.Color(rgb.Gruen, rgb.Rot, rgb.Blau));
    } else {
      strip.setPixelColor(cnt, 0);
    }
  }
  strip.show();
}

//*************************************************
// konvertieren zu RGB
//*************************************************
struct RGB Convert2RGB(struct HSV HSVdata) {
  float r, g, b;
  struct RGB RGBdata;

  // Berechnen Farbwinkel -> RGB
  // 0-60 Grad - Rot nach Gelb
  if (HSVdata.Winkel <= 60) {
    RGBdata.Rot = HSVdata.Hell;
    RGBdata.Gruen = map(HSVdata.Winkel, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = 0;
  }
  // 60-120 Gelb nach gruen
  if ((HSVdata.Winkel > 60) && (HSVdata.Winkel <= 120)) {
    RGBdata.Rot = HSVdata.Hell - map(HSVdata.Winkel - 60, 0, 60, 0, HSVdata.Hell);
    RGBdata.Gruen = HSVdata.Hell;  //map(HSVdata.Winkel, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = 0;
  }
  // 120-180 gruen nach cyan
  if ((HSVdata.Winkel > 120) && (HSVdata.Winkel <= 180)) {
    RGBdata.Rot = 0;               // HSVdata.Hell - map(HSVdata.Winkel-60, 0, 60, 0, HSVdata.Hell);
    RGBdata.Gruen = HSVdata.Hell;  //map(HSVdata.Winkel, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = map(HSVdata.Winkel - 120, 0, 60, 0, HSVdata.Hell);
  }
  // 180-240 cyan nach blau
  if ((HSVdata.Winkel > 180) && (HSVdata.Winkel <= 240)) {
    RGBdata.Rot = 0;
    RGBdata.Gruen = HSVdata.Hell - map(HSVdata.Winkel - 180, 0, 60, 0, HSVdata.Hell);
    RGBdata.Blau = HSVdata.Hell;
  }
  // 240-300  blau nach Magenta
  if ((HSVdata.Winkel > 240) && (HSVdata.Winkel <= 300)) {
    RGBdata.Rot = map(HSVdata.Winkel - 240, 0, 60, 0, HSVdata.Hell);
    RGBdata.Gruen = 0;
    RGBdata.Blau = HSVdata.Hell;
  }
  // 300-360  Magenta nach rot
  if (HSVdata.Winkel > 300) {
    RGBdata.Rot = HSVdata.Hell;
    RGBdata.Gruen = 0;
    RGBdata.Blau = HSVdata.Hell - map(HSVdata.Winkel - 300, 0, 60, 0, HSVdata.Hell);
  }
  // Berechnen Sättigung
  float Faktor = (HSVdata.Satt / 255);
  RGBdata.Rot = RGBdata.Rot * Faktor + HSVdata.Hell * (1 - Faktor);
  RGBdata.Gruen = RGBdata.Gruen * Faktor + HSVdata.Hell * (1 - Faktor);
  RGBdata.Blau = RGBdata.Blau * Faktor + HSVdata.Hell * (1 - Faktor);
  return (RGBdata);
}

//*************************************************
// Ausgabe auf Neostrip
//*************************************************
void StripOut(int von, int bis, struct RGB rgbData) {
  int cnt;

  for (cnt = von; cnt < bis; cnt++) {
    strip.setPixelColor(cnt, strip.Color(rgbData.Gruen, rgbData.Rot, rgbData.Blau));
  }
  strip.show();
}
