/*
   Datenlogger mit Arduino
   Analogeingänge 0..7 entsprechen Kanälen 1..8

   Ansteuerung über Seriell

   1..8 [CR]
   entsprechender Kanal 1...8 wird ausgelesen und übergeben
   A[CR] oder a[CR]
   alle Kanäler werden audsgeleden und übergeben

  R[CR] oder r[CR]
  Reset oder Restart
  gibt aus:
   START [CR][LF]
   HEAD  [CR][LF]

   alle anderen Eingaben durch [CR] abgeschlossen werden die auf dem
   DIP-Schalter akivierten Kanäle übergeben. (auf GND gelegt)

   Dabei gilt die Zuordnung
   Kanal 1 -> A0 -> D12
   Kanal 2 -> A1 -> D11
   Kanal 3 -> A2 -> D10
   Kanal 4 -> A3 -> D9
   Kanal 5 -> A4 -> D8
   Kanal 6 -> A5 -> D7
   Kanal 7 -> A6 -> D6
   Kanal 8 -> A7 -> D5

   Ausgabeformat über Seriell:
   START [CR][LF]         (Programmstart -> Clear Page)
   HEAD  [CR][LF]         (Überschriften aus Excel)
   KANAL,4,123 [CR][LF]   (zB: Kanal 4 mit Wert 123)
*/

const int SW[] = {12, 11, 10, 9, 8, 7, 6, 5};
const int analog[] = {A0, A1, A2, A3, A4, A5, A6, A7};
const int baud = 9600;

void setup() {

  int cnt;
  //  Digitale Schalter setzen
  for (cnt = 0; cnt < 8; cnt++) {
    pinMode (SW[cnt], INPUT);
    digitalWrite(SW[cnt], HIGH);
  }
  Serial.begin(baud);
  Serial.println("Datalogger  Version 0.0");
  Serial.println("START");
  Serial.println("HEAD");
}
byte inByte;
byte kByte = 0;
int wert;
char ausgabe[255];

void loop() {
  int cnt;
  do {
    kByte = inByte;
    while (Serial.available() == 0);
    inByte = Serial.read();
  }
  while (inByte != 13);
  // Serial.println(kByte);
  if ((kByte == 82) || (kByte == 114)) {
    // Reset (r - R)
    Serial.println("START");
    Serial.println("HEAD");
  } else {
    if ((kByte < 49) || (kByte > 56)) {
      // alle Kanäle bzw. DIP Schalter
      for (cnt = 0; cnt < 8; cnt++) {
        //digitalWrite(SW[cnt],LOW);
        //digitalWrite(SW[cnt],HIGH);

        if ((digitalRead(SW[cnt]) == LOW) || (kByte == 97) || (kByte == 65)) {

          wert = analogRead(analog[cnt]);
          sprintf(ausgabe, "KANAL, %d, %4d", cnt + 1, wert);
          Serial.println(ausgabe);
        }
      }
    } else {
      wert = analogRead(analog[kByte - 49]);
      sprintf(ausgabe, "KANAL %d, %4d", kByte - 48, wert);
      Serial.println(ausgabe);
      kByte = 0;
    }
  }
}
